use DocumentTools in 
#
# Application    = Stone_throwing
# Component.name = Plot_Generate
# Component.type = Button
#
# Omer Yagel,   15 - Feb - 2010
#

# Input
x0 		:= Do(%Input_x0); 
y0 		:= Do(%Input_y0); 
V0		:= Do(%V_mag);
alpha 	:= Do(%Dial_Angle0)*Pi/180;
v_x 	:= V0 * cos(alpha); 
v_y 	:= V0 * sin(alpha);

# ODE system
odesys := ode1, ode2;
BoundaryConditions := x(0) = x0, (D(x))(0) = v_x, y(0) = y0, (D(y))(0) = v_y;

# Solutions
Sol := dsolve({odesys, BoundaryConditions}, numeric, output = listprocedure);
xp := subs(Sol, x(t));
yp := subs(Sol, y(t));

# Animation Objects
ball 		:= proc (t) 
				pointplot([xp(t), yp(t)], 	view = [0 .. 500, 0 .. 200], 
											symbol = solidcircle, 
											symbolsize = 15, 
											color = red) 
			end proc;
ballNoDrag 	:= proc (t) 
				pointplot([v_x*t, y0+v_y*t-(1/2)*g*t^2], view = [0 .. 500, 0 .. 200], 
														 symbol = solidcircle, 
														 symbolsize = 20, 
														 color = blue)
			end proc;


# Plots
P31 := odeplot(Sol, [x(t), y(t)], t = 0 .. 10); 
P32 := plot([v_x*t, y0+v_y*t-(1/2)*g*t^2, t = 0 .. 10], color = blue);
P33 := animate(ball, [t], t = 0 .. 10);
P34 := animate(ballNoDrag, [t], t = 0 .. 10);


# Output
Do(%Plot0 = display(P31, P32, P34, P33));


end use;
